/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Ice;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectProxySeqHelper;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.UserException;
import com.zeroc.IceInternal.Incoming;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public interface Router
extends Object {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public GetClientProxyResult getClientProxy(Current var1);

    public ObjectPrx getServerProxy(Current var1);

    public ObjectPrx[] addProxies(ObjectPrx[] var1, Current var2);

    @Override
    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    @Override
    default public String ice_id(Current current) {
        return Router.ice_staticId();
    }

    public static String ice_staticId() {
        return "::Ice::Router";
    }

    public static CompletionStage<OutputStream> _iceD_getClientProxy(Router obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        GetClientProxyResult ret = obj.getClientProxy(current);
        OutputStream ostr = inS.startWriteParams();
        ret.write(ostr);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getServerProxy(Router obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        ObjectPrx ret = obj.getServerProxy(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_addProxies(Router obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        ObjectPrx[] iceP_proxies = ObjectProxySeqHelper.read(istr);
        inS.endReadParams();
        ObjectPrx[] ret = obj.addProxies(iceP_proxies, current);
        OutputStream ostr = inS.startWriteParams();
        ObjectProxySeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    @Override
    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return Router._iceD_addProxies(this, in, current);
            }
            case 1: {
                return Router._iceD_getClientProxy(this, in, current);
            }
            case 2: {
                return Router._iceD_getServerProxy(this, in, current);
            }
            case 3: {
                return Object._iceD_ice_id(this, in, current);
            }
            case 4: {
                return Object._iceD_ice_ids(this, in, current);
            }
            case 5: {
                return Object._iceD_ice_isA(this, in, current);
            }
            case 6: {
                return Object._iceD_ice_ping(this, in, current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Ice::Object", "::Ice::Router"};
        _iceOps = new String[]{"addProxies", "getClientProxy", "getServerProxy", "ice_id", "ice_ids", "ice_isA", "ice_ping"};
    }

    public static class GetClientProxyResult {
        public ObjectPrx returnValue;
        public Optional<Boolean> hasRoutingTable;

        public GetClientProxyResult() {
        }

        public GetClientProxyResult(ObjectPrx returnValue, Optional<Boolean> hasRoutingTable) {
            this.returnValue = returnValue;
            this.hasRoutingTable = hasRoutingTable;
        }

        public GetClientProxyResult(ObjectPrx returnValue, boolean hasRoutingTable) {
            this.returnValue = returnValue;
            this.hasRoutingTable = Optional.of(hasRoutingTable);
        }

        public void write(OutputStream ostr) {
            ostr.writeProxy(this.returnValue);
            ostr.writeBool(1, this.hasRoutingTable);
        }

        public void read(InputStream istr) {
            this.returnValue = istr.readProxy();
            this.hasRoutingTable = istr.readBool(1);
        }
    }
}

