/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsIrAttributesKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.ObjectLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ObjectDeclarationLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "irNullabilityCheck", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "instanceField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nObjectLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ObjectDeclarationLowering\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 LowerUtils.kt\norg/jetbrains/kotlin/backend/common/lower/LowerUtilsKt\n+ 5 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBuilderKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n*L\n1#1,153:1\n75#2,4:154\n125#3:158\n96#4:159\n247#5,5:160\n76#6,2:165\n*S KotlinDebug\n*F\n+ 1 ObjectLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ObjectDeclarationLowering\n*L\n48#1:154,4\n62#1:158\n65#1:159\n65#1:160,5\n65#1:165,2\n*E\n"})
public final class ObjectDeclarationLowering
implements DeclarationTransformer {
    @NotNull
    private final JsCommonBackendContext context;

    public ObjectDeclarationLowering(@NotNull JsCommonBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @NotNull
    public final JsCommonBackendContext getContext() {
        return this.context;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (!(declaration instanceof IrClass) || ((IrClass)declaration).getKind() != ClassKind.OBJECT || IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)declaration)) {
            return null;
        }
        IrSimpleFunction getInstanceFun = ObjectLoweringKt.access$getOrCreateGetInstanceFunction((IrClass)declaration);
        Object $this$buildField$iv = this.context.getIrFactory();
        boolean $i$f$buildField = false;
        IrFieldBuilder $this$buildField_u24lambda_u241$iv = new IrFieldBuilder();
        boolean bl = false;
        IrFieldBuilder $this$transformFlat_u24lambda_u240 = $this$buildField_u24lambda_u241$iv;
        boolean bl2 = false;
        Name name2 = Name.identifier(((IrClass)declaration).getName().asString() + "_instance");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        $this$transformFlat_u24lambda_u240.setName(name2);
        $this$transformFlat_u24lambda_u240.setType(IrTypesKt.makeNullable(IrUtilsKt.getDefaultType((IrClass)declaration)));
        $this$transformFlat_u24lambda_u240.setStatic(true);
        $this$transformFlat_u24lambda_u240.setOrigin(IrDeclarationOrigin.Companion.getFIELD_FOR_OBJECT_INSTANCE());
        Object $this$transformFlat_u24lambda_u241 = $this$buildField$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv, $this$buildField_u24lambda_u241$iv);
        boolean bl3 = false;
        ((IrDeclarationBase)$this$transformFlat_u24lambda_u241).setParent(((IrClass)declaration).getParent());
        ((IrField)$this$transformFlat_u24lambda_u241).setInitializer(null);
        Object instanceField = $this$buildField$iv;
        JsIrAttributesKt.setObjectInstanceField((IrClass)declaration, (IrField)instanceField);
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor((IrClass)declaration);
        if (irConstructor == null) {
            IrConstructor irConstructor2 = JsIrAttributesKt.getSyntheticPrimaryConstructor((IrClass)declaration);
            irConstructor = irConstructor2;
            Intrinsics.checkNotNull(irConstructor2);
        }
        IrConstructor primaryConstructor = irConstructor;
        IrDeclarationParent $this$safeAs$iv = ((IrClass)declaration).getParent();
        boolean $i$f$safeAs = false;
        IrDeclarationParent irDeclarationParent = $this$safeAs$iv;
        if (!(irDeclarationParent instanceof IrClass)) {
            irDeclarationParent = null;
        }
        IrClass irClass = (IrClass)irDeclarationParent;
        IrSimpleFunction initEntryInstancesFun = irClass != null ? JsIrAttributesKt.getInitEntryInstancesFun(irClass) : null;
        getInstanceFun.setBody(IrFactoryHelpersKt.createBlockBody(this.context.getIrFactory(), -1, -1, arg_0 -> ObjectDeclarationLowering.transformFlat$lambda$2(this, getInstanceFun, initEntryInstancesFun, (IrField)instanceField, primaryConstructor, arg_0)));
        IrDeclaration[] irDeclarationArray = new IrDeclaration[]{declaration, instanceField, getInstanceFun};
        return CollectionsKt.listOf(irDeclarationArray);
    }

    private final IrExpression irNullabilityCheck(IrBuilderWithScope $this$irNullabilityCheck, IrField instanceField) {
        JsCommonBackendContext context2 = this.context;
        return context2 instanceof JsIrBackendContext && ((JsIrBackendContext)context2).getEs6mode() ? ExpressionHelpersKt.irEqeqeqWithoutBox($this$irNullabilityCheck, ExpressionHelpersKt.irGetField$default($this$irNullabilityCheck, null, instanceField, null, 4, null), IrJsUtilsKt.getVoid((JsIrBackendContext)context2)) : ExpressionHelpersKt.irEqualsNull($this$irNullabilityCheck, ExpressionHelpersKt.irGetField$default($this$irNullabilityCheck, null, instanceField, null, 4, null));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit transformFlat$lambda$2(ObjectDeclarationLowering this$0, IrSimpleFunction $getInstanceFun, IrSimpleFunction $initEntryInstancesFun, IrField $instanceField, IrConstructor $primaryConstructor, IrBlockBody $this$createBlockBody) {
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $this$irBlockBody$iv$iv;
        void $this$irBlockBody$iv;
        Intrinsics.checkNotNullParameter($this$createBlockBody, "$this$createBlockBody");
        Collection collection = $this$createBlockBody.getStatements();
        Object object = LowerUtilsKt.createIrBuilder$default(this$0.context, (IrSymbol)$getInstanceFun.getSymbol(), 0, 0, 6, null);
        IrElement irElement$iv = $getInstanceFun;
        boolean $i$f$irBlockBody = false;
        void var10_10 = $this$irBlockBody$iv;
        int n2 = irElement$iv.getStartOffset();
        int endOffset$iv$iv = irElement$iv.getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
        boolean $i$f$blockBody = false;
        void $this$transformFlat_u24lambda_u242_u240 = this_$iv$iv$iv;
        boolean bl = false;
        if ($initEntryInstancesFun != null) {
            $this$transformFlat_u24lambda_u242_u240.unaryPlus(ExpressionHelpersKt.irCall((IrBuilder)$this$transformFlat_u24lambda_u242_u240, $initEntryInstancesFun));
        }
        $this$transformFlat_u24lambda_u242_u240.unaryPlus(LowerUtilsKt.irIfThen((IrBuilderWithScope)$this$transformFlat_u24lambda_u242_u240, this$0.irNullabilityCheck((IrBuilderWithScope)$this$transformFlat_u24lambda_u242_u240, $instanceField), ExpressionHelpersKt.irCallConstructor((IrBuilder)$this$transformFlat_u24lambda_u242_u240, $primaryConstructor.getSymbol(), CollectionsKt.emptyList())));
        $this$transformFlat_u24lambda_u242_u240.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$transformFlat_u24lambda_u242_u240, ExpressionHelpersKt.irGetField$default((IrBuilder)$this$transformFlat_u24lambda_u242_u240, null, $instanceField, null, 4, null)));
        object = this_$iv$iv$iv.doBuild().getStatements();
        CollectionsKt.addAll(collection, object);
        return Unit.INSTANCE;
    }
}

