/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.stream.StreamMappingAttribute;
import org.jkiss.dbeaver.tools.transfer.stream.StreamMappingType;

public class StreamMappingContainer
implements DBPNamedObject,
DBPImageProvider {
    private final DBSDataContainer source;
    private final List<StreamMappingAttribute> attributes;

    public StreamMappingContainer(@NotNull DBSDataContainer source) {
        this.source = source;
        this.attributes = new ArrayList<StreamMappingAttribute>();
    }

    public StreamMappingContainer(@NotNull StreamMappingContainer other) {
        this.source = other.source;
        this.attributes = new ArrayList<StreamMappingAttribute>();
        for (StreamMappingAttribute attribute : other.attributes) {
            this.attributes.add(new StreamMappingAttribute(this, attribute));
        }
    }

    public boolean isComplete() {
        boolean valid = false;
        for (StreamMappingAttribute attribute : this.attributes) {
            if (attribute.getMappingType() == StreamMappingType.unspecified) {
                return false;
            }
            if (attribute.getMappingType() != StreamMappingType.export) continue;
            valid = true;
        }
        return valid;
    }

    @NotNull
    public DBPImage getObjectImage() {
        return DBIcon.TREE_TABLE;
    }

    @NotNull
    public String getName() {
        return DBUtils.getObjectFullName((DBPNamedObject)this.source, (DBPEvaluationContext)DBPEvaluationContext.UI);
    }

    @NotNull
    public DBSDataContainer getSource() {
        return this.source;
    }

    @Nullable
    public StreamMappingAttribute getAttribute(@NotNull DBSAttributeBase sourceAttribute) {
        for (StreamMappingAttribute mappingAttribute : this.attributes) {
            if (!mappingAttribute.getAttribute().getName().equals(sourceAttribute.getName())) continue;
            return mappingAttribute;
        }
        return null;
    }

    @NotNull
    public List<StreamMappingAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) {
        if (this.attributes.isEmpty()) {
            try {
                try {
                    monitor.beginTask("Load attributes from '" + this.getName() + "'", 1);
                    for (DBSAttributeBase attribute : DTUtils.getAttributes(monitor, this.source, this)) {
                        this.attributes.add(new StreamMappingAttribute(this, attribute, StreamMappingType.unspecified));
                    }
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError(DTMessages.stream_transfer_consumer_title_attributes_read_failed, NLS.bind((String)DTMessages.stream_transfer_consumer_message_cannot_get_attributes_from, (Object)this.getName()), (Throwable)e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
        return this.attributes;
    }

    @Nullable
    public StreamMappingType getMappingType() {
        StreamMappingType[] types = (StreamMappingType[])this.attributes.stream().map(StreamMappingAttribute::getMappingType).distinct().toArray(StreamMappingType[]::new);
        if (types.length == 1) {
            return types[0];
        }
        return null;
    }

    public void setMappingType(@NotNull StreamMappingType type) {
        for (StreamMappingAttribute attribute : this.attributes) {
            attribute.setMappingType(type);
        }
    }

    public void loadSettings(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> containerSettings) {
        Map attributes = JSONUtils.getObject(containerSettings, (String)"attributes");
        for (StreamMappingAttribute attribute : this.getAttributes(monitor)) {
            Map attributeSettings = JSONUtils.getObjectOrNull((Map)attributes, (String)attribute.getName());
            if (attributeSettings == null) continue;
            attribute.loadSettings(monitor, attributeSettings);
        }
    }

    public void saveSettings(@NotNull Map<String, Object> containerSettings) {
        LinkedHashMap<String, LinkedHashMap<String, Object>> attributesSettings = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        for (StreamMappingAttribute attribute : this.attributes) {
            LinkedHashMap<String, Object> attributeSettings = new LinkedHashMap<String, Object>();
            attribute.saveSettings(attributeSettings);
            attributesSettings.put(attribute.getName(), attributeSettings);
        }
        containerSettings.put("attributes", attributesSettings);
    }
}

