/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.unit;

import java.util.HashMap;
import java.util.Map;
import org.openjdk.jmc.common.unit.BinaryPrefix;
import org.openjdk.jmc.common.unit.BinaryScaleFactor;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.ScalarQuantity;
import org.openjdk.jmc.common.unit.ScaleFactor;
import org.openjdk.jmc.common.unit.TypedUnit;

public class BinaryUnitSelector
implements LinearKindOfQuantity.LinearUnitSelector {
    protected final LinearKindOfQuantity kindOfQuantity;
    protected final Map<ScaleFactor, LinearUnit> unitCache = new HashMap<ScaleFactor, LinearUnit>();

    public BinaryUnitSelector(LinearKindOfQuantity kindOfQuantity) {
        this.kindOfQuantity = kindOfQuantity;
        this.unitCache.put(BinaryScaleFactor.get(0), kindOfQuantity.atomUnit);
    }

    public BinaryUnitSelector(LinearKindOfQuantity kindOfQuantity, Iterable<BinaryPrefix> prefixes) {
        this(kindOfQuantity);
        for (BinaryPrefix prefix : prefixes) {
            this.unitCache.put(prefix.scaleFactor(), kindOfQuantity.getUnit(prefix));
        }
    }

    @Override
    public LinearUnit getPreferredUnit(ITypedQuantity<LinearUnit> quantity, double minNumericalValue, double maxNumericalValue) {
        LinearUnit atomUnit = this.kindOfQuantity.atomUnit;
        double absVal = Math.abs(quantity.doubleValueIn(atomUnit));
        if (absVal > minNumericalValue && absVal < maxNumericalValue) {
            return atomUnit;
        }
        if (minNumericalValue > 1.0) {
            return this.getRegularUnit(absVal / minNumericalValue);
        }
        return this.getRegularUnit(absVal);
    }

    private LinearUnit getRegularUnit(double absValInAtomUnit) {
        BinaryScaleFactor factor = BinaryScaleFactor.getFloor1024Factor(absValInAtomUnit);
        return this.getUnit(factor);
    }

    private LinearUnit getUnit(BinaryScaleFactor factor) {
        LinearUnit unit = this.unitCache.get(factor);
        if (unit == null) {
            String unitName = factor.asExponentialStringBuilder(true).append(this.kindOfQuantity.atomUnit.getAppendableSuffix(false)).toString();
            unit = new LinearUnit(this.kindOfQuantity, null, factor, unitName, unitName, new String[0]);
            this.unitCache.put(factor, unit);
        }
        return unit;
    }

    @Override
    public ITypedQuantity<LinearUnit> snapToBestBetweenHalfAndEqual(ITypedQuantity<LinearUnit> upperLimit) {
        assert (Math.abs(upperLimit.doubleValue()) > 0.0);
        TypedUnit quantaUnit = this.getPreferredUnit((ITypedQuantity)upperLimit, 1.0, 1024.0);
        int quantaLog2 = BinaryPrefix.getFloorLog2(upperLimit.doubleValueIn(quantaUnit));
        if (quantaLog2 >= 0) {
            long quantaSize = 1L << quantaLog2;
            return ((LinearUnit)quantaUnit).quantity(quantaSize);
        }
        return ((LinearUnit)quantaUnit).quantity(Math.scalb(1.0f, quantaLog2));
    }

    @Override
    public LinearUnit getLargestExactUnit(ITypedQuantity<LinearUnit> quantity) {
        int log1024;
        if (quantity.doubleValue() == 0.0) {
            return (LinearUnit)quantity.getUnit();
        }
        if (quantity instanceof ScalarQuantity.LongStored) {
            long val = quantity.longValue();
            if (val == 0L) {
                return this.kindOfQuantity.atomUnit;
            }
            log1024 = BinaryPrefix.getAlignmentLog1024(val);
        } else {
            double val = quantity.doubleValue();
            if (val == 0.0) {
                return this.kindOfQuantity.atomUnit;
            }
            log1024 = BinaryPrefix.getAlignmentLog1024(val);
        }
        ScaleFactor factor = BinaryScaleFactor.get(log1024 * 10);
        factor = ((ScaleFactor)factor).concat(((LinearUnit)quantity.getUnit()).valueTransformTo(this.kindOfQuantity.atomUnit));
        LinearUnit unit = this.unitCache.get(factor);
        if (unit != null && unit.getIdentifier() != null) {
            return unit;
        }
        return null;
    }
}

