/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.AuthenticationException;
import org.apache.tomcat.websocket.Authenticator;

public class DigestAuthenticator
extends Authenticator {
    private static final StringManager sm = StringManager.getManager(DigestAuthenticator.class);
    public static final String schemeName = "digest";
    private static final Object cnonceGeneratorLock = new Object();
    private static volatile SecureRandom cnonceGenerator;
    private int nonceCount = 0;
    private long cNonce;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAuthorization(String string, String string2, String string3, String string4, String string5) throws AuthenticationException {
        this.validateUsername(string3);
        this.validatePassword(string4);
        Map<String, String> map = this.parseAuthenticateHeader(string2);
        String string6 = map.get("realm");
        this.validateRealm(string5, string6);
        String string7 = map.get("nonce");
        String string8 = map.get("qop");
        String string9 = map.get("algorithm") == null ? "MD5" : map.get("algorithm");
        String string10 = map.get("opaque");
        StringBuilder stringBuilder = new StringBuilder();
        if (!string8.isEmpty()) {
            if (cnonceGenerator == null) {
                Object object = cnonceGeneratorLock;
                synchronized (object) {
                    if (cnonceGenerator == null) {
                        cnonceGenerator = new SecureRandom();
                    }
                }
            }
            this.cNonce = cnonceGenerator.nextLong();
            ++this.nonceCount;
        }
        stringBuilder.append("Digest ");
        stringBuilder.append("username =\"" + string3 + "\",");
        stringBuilder.append("realm=\"" + string6 + "\",");
        stringBuilder.append("nonce=\"" + string7 + "\",");
        stringBuilder.append("uri=\"" + string + "\",");
        try {
            stringBuilder.append("response=\"" + this.calculateRequestDigest(string, string3, string4, string6, string7, string8, string9) + "\",");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthenticationException(sm.getString("digestAuthenticator.algorithm", new Object[]{noSuchAlgorithmException.getMessage()}));
        }
        stringBuilder.append("algorithm=" + string9 + ",");
        stringBuilder.append("opaque=\"" + string10 + "\",");
        if (!string8.isEmpty()) {
            stringBuilder.append("qop=\"" + string8 + "\"");
            stringBuilder.append(",cnonce=\"" + this.cNonce + "\",");
            stringBuilder.append("nc=" + String.format("%08X", this.nonceCount));
        }
        return stringBuilder.toString();
    }

    private String calculateRequestDigest(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws NoSuchAlgorithmException {
        boolean bl = false;
        if (string7.endsWith("-sess")) {
            string7 = string7.substring(0, string7.length() - 5);
            bl = true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string8 = bl ? this.encode(string7, string2 + ":" + string4 + ":" + string3) + ":" + string5 + ":" + this.cNonce : string2 + ":" + string4 + ":" + string3;
        String string9 = "GET:" + string;
        stringBuilder.append(this.encode(string7, string8));
        stringBuilder.append(':');
        stringBuilder.append(string5);
        if (string6.toLowerCase().contains("auth")) {
            stringBuilder.append(':');
            stringBuilder.append(String.format("%08X", this.nonceCount));
            stringBuilder.append(':');
            stringBuilder.append(String.valueOf(this.cNonce));
            stringBuilder.append(':');
            stringBuilder.append(string6);
        }
        stringBuilder.append(':');
        stringBuilder.append(this.encode(string7, string9));
        return this.encode(string7, stringBuilder.toString());
    }

    private String encode(String string, String string2) throws NoSuchAlgorithmException {
        byte[] byArray = string2.getBytes(StandardCharsets.ISO_8859_1);
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        byte[] byArray2 = messageDigest.digest(byArray);
        return HexUtils.toHexString((byte[])byArray2);
    }

    @Override
    public String getSchemeName() {
        return schemeName;
    }
}

